#!/bin/sh

touch /tmp/bad_apple_playing

export LD_LIBRARY_PATH=/mnt/us/extensions/bad_apple/library:$LD_LIBRARY_PATH

filename=$1
volume=`cat /mnt/us/extensions/bad_apple/VOLUME`
 
/mnt/us/extensions/bad_apple/soxi "$filename" > /var/tmp/soxidata.txt

Chan=$(awk -F: '/Channels/ {gsub(" ","");print $2}' /var/tmp/soxidata.txt)

Wide=$(awk -F: '/Precision/ {gsub(" ","");gsub("-bit","");print $2}' /var/tmp/soxidata.txt)

Rate=$(awk -F: '/Sample Rate/ {gsub(" ","");print $2}' /var/tmp/soxidata.txt)

rm /var/tmp/soxidata.txt
/mnt/us/extensions/bad_apple/sox -v $volume "$filename" -t raw - |  /usr/bin/gst-launch \
    filesrc location=/dev/stdin \
    ! audio/x-raw-int, \
    endianness='(int)'1234, \
    signed='(boolean)'true, \
    width='(int)'$Wide, \
    depth='(int)'$Wide, \
    rate='(int)'$Rate, \
    channels='(int)'$Chan \
    ! queue \
    ! mixersink

rm /tmp/bad_apple_playing